% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\name{convert}
\alias{convert}
\title{Converts chains from the Bayesian estimation of a multivariate TAR model to a mcmc object.}
\usage{
convert(object)
}
\arguments{
\item{object}{an object of the class \emph{mtar}.}
}
\value{
a \code{mcmc}-type object.
}
\description{
This function converts the chains obtained from the Bayesian estimation of a multivariate TAR model to a \code{mcmc} object to be analyzed with the \pkg{coda} package.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1 <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
             dist="Gaussian", ars=list(p=c(1,1,2)), n.burnin=100,
             n.sim=3000, n.thin=2)
chains1 <- convert(fit1)
summary(chains1$location[[1]])
plot(chains1$location[[1]])

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2 <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
             dist="Gaussian", ars=list(p=c(5,5,5)), n.burnin=2000,
             n.sim=3000, n.thin=2)
chains2 <- convert(fit2)
summary(chains2$location[[2]])
plot(chains2$location[[2]])
}

}
