% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{eaf_as_list}
\alias{eaf_as_list}
\title{Convert an EAF data frame to a list of data frames, where each element
of the list is one attainment surface. The function \code{\link[=attsurf2df]{attsurf2df()}} can be
used to convert the list into a single data frame.}
\usage{
eaf_as_list(eaf)
}
\arguments{
\item{eaf}{\code{data.frame()}|\code{matrix()}\cr Data frame or matrix that represents the EAF.}
}
\value{
\code{list()}\cr A list of data frames. Each \code{data.frame} represents one attainment surface.
}
\description{
Convert an EAF data frame to a list of data frames, where each element
of the list is one attainment surface. The function \code{\link[=attsurf2df]{attsurf2df()}} can be
used to convert the list into a single data frame.
}
\examples{
extdata_path <- system.file(package="moocore", "extdata")
x <- read_datasets(file.path(extdata_path, "example1_dat"))
attsurfs <- eaf_as_list(eaf(x, percentiles = c(0, 50, 100)))
str(attsurfs)
}
\seealso{
\code{\link[=eaf]{eaf()}} \code{\link[=attsurf2df]{attsurf2df()}}
}
\concept{eaf}
