% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interop-car.R
\name{h_first_term_containing_categ}
\alias{h_first_term_containing_categ}
\title{Identify the First Term in a Model to Contain a Categorical Variable}
\usage{
h_first_term_containing_categ(factors, categorical)
}
\arguments{
\item{factors}{(matrix)\cr the \code{factors} attribute of a \code{\link{terms.object}},
which is a matrix of 0s, 1s, and 2s.}

\item{categorical}{(character)\cr a vector of the categorical variables in
the model whose \code{\link{terms.object}} is \code{factors}.}
}
\value{
A \code{string}: one of the column names of \code{factors}. If none of the
columns contain a categorical variable, \code{NULL} is returned.
}
\description{
This returns the column name of the leftmost column of \code{factors} containing a
nonzero value in a row corresponding to a \code{categorical} variable.
}
\keyword{internal}
