% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interop-car.R
\name{Anova.mmrm}
\alias{Anova.mmrm}
\title{Conduct type II/III hypothesis testing on the MMRM fit results.}
\usage{
Anova.mmrm(
  mod,
  type = c("II", "III", "2", "3"),
  tol = sqrt(.Machine$double.eps),
  test.statistic = c("F", "Chisq"),
  ...
)
}
\arguments{
\item{mod}{(\code{mmrm})\cr the fitted MMRM.}

\item{type}{(\code{string})\cr either \code{"II"}, \code{"III"}, \code{"2"}, or \code{"3"}, indicating the
type of test to perform.}

\item{tol}{(\code{numeric}) threshold below which values are treated as 0.}

\item{test.statistic}{(\code{string})\cr either \verb{"F} or \code{"Chisq"}, indicating the
kind of test to perform.}

\item{...}{arguments passed from other methods.}
}
\description{
Conduct type II/III hypothesis testing on the MMRM fit results.
}
\details{
\code{Anova()} will return an \code{anova} object with one row per variable.

If \code{test.statistic = "F"}, columns will be \code{Df}(numerator degrees of
freedom), \code{Res.Df} (denominator degrees of freedom), \code{F}, and
\verb{Pr(>F)}.

If \code{test.statistic = "Chisq"}, columns will be \code{Chisq} (the Chi-squared
test statistic), \code{Df} (degrees of freedom), and \verb{Pr(>Chisq)} (p-value).
}
\keyword{internal}
