% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_dmrs.R
\name{summarize_dmrs}
\alias{summarize_dmrs}
\title{Summarize DMR results from \code{mmcmcBayes}}
\usage{
summarize_dmrs(dmr_table)
}
\arguments{
\item{dmr_table}{A data frame of DMRs, typically the return value of
\code{mmcmcBayes()}.}
}
\value{
An object of class \code{"mmcmcBayes_dmr_summary"}, which is a list with
elements:
\itemize{
  \item \code{n_dmrs}: Total number of detected DMRs.
  \item \code{size_summary}: Named numeric vector of summary statistics for
    \code{CpG_Count} (min, 1st quartile, median, mean, 3rd quartile, max),
    or \code{NULL} if \code{CpG_Count} is not available.
  \item \code{decision_summary}: Named numeric vector of summary statistics
    for \code{Decision_Value} (min, 1st quartile, median, mean,
    3rd quartile, max), or \code{NULL} if \code{Decision_Value} is not
    available.
  \item \code{by_chromosome}: A data frame with counts of DMRs per
    chromosome, or \code{NULL} if \code{Chromosome} is not available.
  \item \code{by_stage}: A data frame with counts of DMRs per stage, if a
    \code{Stage} column is present; otherwise \code{NULL}.
}
}
\description{
Convenience function to summarize the DMR table returned by
\code{mmcmcBayes()}. It reports the number of detected regions, summaries of
region sizes and decision values, and counts by chromosome and (optionally)
by stage.
}
\details{
The function is designed to work with the data frame returned by
\code{mmcmcBayes()}. At minimum, the input \code{dmr_table} is expected to
contain the columns \code{Chromosome}, \code{CpG_Count}, and
\code{Decision_Value}. If a \code{Stage} column is present, counts by stage
are also reported.

If \code{dmr_table} is \code{NULL} or has zero rows, a summary object with
\code{n_dmrs = 0} is returned and all other components are \code{NULL}.
}
\examples{
\donttest{
data(cancer_demo)
data(normal_demo)

mcmc <- list(nburn = 1000, niter = 2000, thin = 1)

set.seed(2021)
dmr_res <- mmcmcBayes(
  cancer_demo, normal_demo,
  stage         = 1,
  max_stages    = 2,
  num_splits    = 5,
  mcmc          = mcmc,
  priors_cancer = NULL,
  priors_normal = NULL,
  bf_thresholds = c(0.5, 0.8, 1.05)
)

summary_res <- summarize_dmrs(dmr_res)
summary_res
}

}
