% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asgn_func.R
\name{asgn_func}
\alias{asgn_func}
\title{Fit an Alpha-Skewed Generalized Normal (ASGN) Distribution by MCMC}
\usage{
asgn_func(
  data,
  priors = NULL,
  mcmc = list(nburn = 5000, niter = 10000, thin = 1),
  seed = NULL
)
}
\arguments{
\item{data}{A numeric vector or a one-column matrix. In typical use this is a
vector of sample-wise regional mean M-values (one per sample).}

\item{priors}{Optional list of prior hyperparameters. If \code{NULL}, weakly
informative priors are constructed from the data. If provided, expected
components are \code{alpha}, \code{mu}, and \code{sigma2}.}

\item{mcmc}{A list of MCMC parameters:
\itemize{
  \item \code{nburn}: Number of burn-in iterations (default: 5000)
  \item \code{niter}: Number of sampling iterations (default: 10000)
  \item \code{thin}: Thinning interval (default: 1)
}}

\item{seed}{Optional integer random seed for reproducibility. If \code{NULL},
no seed is set.}
}
\value{
A list with the following elements:
\itemize{
  \item \code{posteriors}: Vector of posterior means for \code{alpha}, \code{mu}, and \code{sigma2}.
  \item \code{summary}: Data frame containing parameter estimates and 95\% credible intervals
        with columns \code{parameter}, \code{estimate}, \code{lower_ci}, and \code{upper_ci}.
}
If there are fewer than two non-missing observations, a default value
\code{posteriors = c(1, 0, 1)} is returned, and \code{summary} is omitted.
}
\description{
\code{asgn_func()} fits an alpha-skewed generalized normal (ASGN) distribution
to univariate numeric data using an MCMC algorithm. The ASGN family provides a
flexible parametric model that can accommodate skewness and, for certain
parameter values, bimodal density shapes.
}
\details{
The input \code{data} may be any univariate numeric sample (vector or a
one-column matrix). In the \code{\link{mmcmcBayes}} workflow, \code{data} is
typically a vector of sample-wise regional mean M-values (one value per sample).
However, \code{asgn_func()} is not specific to DNA methylation and can be used
more generally for fitting skewed or potentially bimodal continuous data.
}
\examples{
\donttest{
# Generate sample data
set.seed(2021)
dt <- rgamma(1000, shape = 2, rate = 1)
dt <- as.matrix(dt, ncol=1)

result <- asgn_func(dt)
print(result$summary)
}

}
\references{
Mahmoudi, E., Jafari, H., & Meshkat, R. (2019).
Alpha-skew generalized normal distribution and its applications.
\emph{Applications and Applied Mathematics: An International Journal (AAM)},
\bold{14}, 784-804.
}
\seealso{
\code{\link{mmcmcBayes}} for the main DMR detection function,
}
\author{
Zhexuan Yang, Duchwan Ryu, and Feng Luan
}
