% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_plot.R
\name{mlts_plot}
\alias{mlts_plot}
\title{Plot results of mlts}
\usage{
mlts_plot(
  fit,
  type = c("fe", "re", "re.cor", "int"),
  bpe = c("median", "mean"),
  what = c("all", "Fixed effect", "Random effect SD", "RE correlation",
    "Outcome prediction", "RE prediction", "Item intercepts", "Loading",
    "Measurement Error SD"),
  sort_est = NULL,
  xlab = NULL,
  ylab = NULL,
  facet_ncol = 1,
  dot_size = 1,
  dot_color = "black",
  dot_shape = 1,
  errorbar_color = "black",
  errorbar_width = 0.3,
  add_true = FALSE,
  true_color = "red",
  true_shape = 22,
  true_size = 1,
  hide_xaxis_text = TRUE,
  par_labels = NULL,
  labels_as_expressions = FALSE
)
}
\arguments{
\item{fit}{An object of class \code{mlts.fit}}

\item{type}{Type of plot.
type = "fe" (Default)
Forest-plot of model coefficients.
type = "re"
Plot of individual (random) effects
type = "int"
Experimental: Plot within-level interactions.
type = "re.cor"
Combined plot depicting the distribution of individual parameter
estimates (posterior summary statistics as provided by \code{bpe}), as
well as bivariate scatter plots.}

\item{bpe}{The Bayesian point estimate is, by default, the median of the
posterior distribution (\code{bpe = "median"}). Set \code{bpe = "mean"} to use
the mean of the posterior distribution as point estimates.}

\item{what}{Character. For \code{type = "fe"}, indicate which parameters should be
included in the plot by setting \code{what} to "all" (the default), or one (or multiple)
of "Fixed effect", "Random effect SD", "RE correlation", "Outcome prediction", "RE prediction",
"Item intercepts", "Loading", or "Measurement Error SD".}

\item{sort_est}{Add parameter label for sorting of random effects.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{facet_ncol}{Number of facet columns (see \code{ggplot2::facet_grid}).}

\item{dot_size}{numeric, size of the dots that indicate the point estimates.}

\item{dot_color}{character. indicating the color of the point estimates.}

\item{dot_shape}{numeric. shape of the dots that indicate the point estimates.}

\item{errorbar_color}{character. Color of error bars.}

\item{errorbar_width}{integer. Width of error bars.}

\item{add_true}{logical. If model was fitted with simulated data using \code{mlts_sim},
true population parameter values can be plotted as reference by setting the argument ot \code{TRUE}.}

\item{true_color}{character. Color of points depicting true population parameter used in the data generation.}

\item{true_shape}{integer. Shape of points depicting true population parameter used in the data generation.}

\item{true_size}{integer. Size of points depicting true population parameter used in the data generation.}

\item{hide_xaxis_text}{logical. Hide x-axis text if set to \code{TRUE}.}

\item{par_labels}{character vector. User-specified labels for random effect parameters
can be specified.}

\item{labels_as_expressions}{logical. Should parameter names on plot labels be printed
as mathematical expressions? Defaults to \code{FALSE}. Still experimental.}
}
\value{
Returns a \code{ggplot}-object .
}
\description{
Plot results of mlts
}
\examples{
\donttest{
# build simple vector-autoregressive mlts model for two time-series variables
var_model <- mlts_model(q = 2)

# fit model with (artificial) dataset ts_data
fit <- mlts_fit(
  model = var_model,
  data = ts_data,
  ts = c("Y1", "Y2"), # time-series variables
  id = "ID", # identifier variable
  time = "time",
  tinterval = 1 # interval for approximation of continuous-time dynamic model,
)

# inspect model summary
mlts_plot(fit, type = "fe", what = "Fixed effect")
}
}
