% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{serial_config}
\alias{serial_config}
\title{Create Serialization Configuration}
\usage{
serial_config(class, sfunc, ufunc)
}
\arguments{
\item{class}{(character) class name(s) for custom serialization, e.g.
\code{'ArrowTabular'} or \code{c('torch_tensor', 'ArrowTabular')}.}

\item{sfunc}{(function | list) serialization function(s) accepting a
reference object and returning a raw vector.}

\item{ufunc}{(function | list) unserialization function(s) accepting a raw
vector and returning a reference object.}
}
\value{
A list comprising the configuration. This should be passed to the
\code{serial} argument of \code{\link[=daemons]{daemons()}}.
}
\description{
Returns a serialization configuration, which may be set to perform custom
serialization and unserialization of normally non-exportable reference
objects, allowing these to be used seamlessly between different R sessions.
Once set by passing to the \code{serial} argument of \code{\link[=daemons]{daemons()}}, the functions
apply to all mirai requests for that compute profile.
}
\details{
This feature utilises the 'refhook' system of R native serialization.
}
\examples{
cfg <- serial_config("test_cls", function(x) serialize(x, NULL), unserialize)
cfg

cfg2 <- serial_config(
  c("class_one", "class_two"),
  list(function(x) serialize(x, NULL), function(x) serialize(x, NULL)),
  list(unserialize, unserialize)
)
cfg2

}
