% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micvar.R
\name{micvar}
\alias{micvar}
\title{Estimate order by mean square information criteria (MIC)}
\usage{
micvar(
  x,
  pmax,
  pmaxst = 2 * pmax,
  method = "ols",
  na.action = stats::na.fail,
  series = deparse1(substitute(x)),
  demean = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{n x p} time series data matrix. Can be univariate or multivariate time series. If x is not a matrix it will be coerced using \code{as.matrix(x)}.}

\item{pmax}{Integer. Maxmium number of lags to consider. Considered lags will to be \code{0},\code{1},...,\code{pmax}.}

\item{pmaxst}{Integer (default is \code{2pmax}). Maximum lag used for computing self-tuned lambda. Must be larger than \code{pmax}.}

\item{method}{Character string (default is "ols"). Specifies method to fit the model. Options are: \code{c("ols", "burg", "mle", "yule-walker", "yw")}. Note this function uses \link[stats]{ar} to perform model fitting.}

\item{na.action}{Function for missing values (default is \code{na.fail}). See the \code{na.action} argument in \link[stats]{ar}.}

\item{series}{Character string. Name of series. See the \code{series} argument in \link[stats]{ar}.}

\item{demean}{Boolean (default is TRUE). Whether or not to demean the series. See the \code{demean} argument in \link[stats]{ar}.}

\item{...}{Additional arguments for specific method. See \link[stats]{ar} and its various methods such as \link[stats]{ar.yw} and \link[stats]{ar.ols} and their corresponding arguments.}
}
\value{
List with elements. Many of these elements are similar to \link[stats]{ar}.
\item{order}{Order of fitted model selected by MIC}
\item{penalized_losses}{Numeric vector of penalized losses for orders \code{0},\code{1},...,\code{pmax}.}
\item{ar}{Estimated autoregression coefficients. See the \code{ar} return value from \link[stats]{ar}.}
\item{var.pred}{Prediction variance. See the \code{var.pred} return value from \link[stats]{ar}.}
\item{x.mean}{Estimated mean. See the \code{x.mean} return value from \link[stats]{ar}.}
\item{x.intercept}{Intercept. See the \code{x.intercept} return value from \link[stats]{ar}.}
\item{n.used}{Number of observations in the time series including missing. See the \code{n.used} return value from \link[stats]{ar}.}
\item{n.obs}{Number of non-missing observations. See the \code{n.obs} return value from \link[stats]{ar}.}
\item{pmax}{The value of \code{pmax} argument.}
\item{partialacf}{Estimate of partial autocorrelation. See the \code{partialacf} return value from \link[stats]{ar}.}
\item{resid}{Residuals from fitted model. See the \code{resid} return value from \link[stats]{ar}.}
\item{method}{Value of \code{method} argument.}
\item{series}{Name of the series. See the \code{series} return value from \link[stats]{ar}.}
\item{call}{Function call.}
\item{asy.var.coef}{Asymptotic-theory variance matrix of coefficient estimates. See the \code{asy.var.coef} return value from \link[stats]{ar}.}
}
\description{
Fits an autoregressive model to the data where the order is selected by minimizing the mean square information criteria. Model fitting is performed using \link[stats]{ar}.
Any of the methods available in the \code{method} argument of \link[stats]{ar} can be used.
}
\details{
This function uses the \link[stats]{ar} functions for fitting. For relevant details of those methods see the Details section of \link[stats]{ar}.
}
\examples{
# multivariate example - default is OLS
VAR3_2_A <- list(gen_coef_mat(3, 0.1, 0.3, 0.8), # lag 1
                 gen_coef_mat(3, 0.1, 0.4 , 0.5)) # lag 2
x <- sim_var(VAR3_2_A, n = 5000)
mic_model <- micvar(x, pmax = 10)

# burg and yule-walker examples
mic_model_burg <- micvar(x, pmax = 10, method = "burg")
mic_model_yw <- micvar(x, pmax = 10, method = "yw")

# univariate example
ar_coefs <- list(matrix(0.3,nrow=1), matrix(0.1,nrow=1))
x <- sim_var(ar_coefs, n = 5000)
mic_model <- micvar(x, pmax = 10)
}
