% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sTab}
\alias{sTab}
\title{Experimental design for the Exp1_R25_pept dataset}
\format{
A data frame with 6 observations on the following 3 variables.
\describe{ 
\item{Sample.name}{a character vector}
\item{Condition}{a character vector} 
\item{Bio.Rep}{a numeric vector} 
}
}
\source{
The \code{DAPARdata} package.
}
\description{
The data frame \code{sTab}  contains the experimental design and gives few informations about the samples. They were obtained using the code \code{pData(Exp1_R25_pept)}.
}
\details{
The \code{DAPARdata}'s \code{Exp1_R25_pept} dataset is the final outcome of a quantitative mass spectrometry-based proteomic analysis of two samples containing different concentrations of 48 human proteins (UPS1 standard from Sigma-Aldrich) within a constant yeast background (see Giai Gianetto et al. (2016) for details). It contains the abundance values of the different human and yeast peptides identified and quantified in these two conditions. The two conditions represent the measured abundances of peptides when respectively 25 fmol and 10 fmol of UPS1 human proteins were mixed with the yeast extract before mass spectrometry analyses. This results in a concentration ratio of 2.5. Three technical replicates were acquired for each condition.
}
\examples{

data(sTab)
str(sTab)

}
\references{
Cox J., Hein M.Y., Luber C.A., Paron I., Nagaraj N., Mann M. Accurate proteome-wide label-free quantification by delayed normalization and maximal peptide ratio extraction, termed MaxLFQ. Mol Cell Proteomics. 2014 Sep, 13(9):2513-26.

Giai Gianetto, Q., Combes, F., Ramus, C., Bruley, C., Coute, Y., Burger, T. (2016). Calibration plot for proteomics: A graphical tool to visually check the assumptions underlying FDR control in quantitative experiments. Proteomics, 16(1), 29-32.
}
\keyword{datasets}
