% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacum.R
\name{metacum.meta}
\alias{metacum.meta}
\alias{metacum}
\alias{metacum.default}
\title{Cumulative meta-analysis}
\usage{
\method{metacum}{meta}(
  x,
  pooled,
  sortvar,
  prediction,
  overall = x$overall,
  text.pooled,
  no = 1,
  cid = NULL,
  cid.below.null = NULL,
  cid.above.null = NULL,
  small.values = "desirable",
  ...
)

metacum(x, ...)

\method{metacum}{default}(x, ...)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{pooled}{A character string indicating whether a common effect
or random effects model is used for pooling. Either missing (see
Details), \code{"common"}, or \code{"random"}, can be abbreviated.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{prediction}{A logical indicating whether to report prediction
intervals.}

\item{overall}{A logical indicating whether overall results should be
reported.}

\item{text.pooled}{A character string used in printouts and forest
plots to label the pooled effect estimate.}

\item{no}{A numeric specifying which meta-analysis results to
consider.}

\item{cid}{A numeric value or vector specifying clinically important
differences (CID) / decision thresholds used to calculate expected
proportions of clinically important benefit or harm
(see \code{\link{cidprop}}).}

\item{cid.below.null}{A single numeric defining the decision threshold below
the null effect to distinguish clinically important from not important
effects (see \code{\link{cidprop}}).}

\item{cid.above.null}{A single numeric defining the decision threshold above
the null effect to distinguish clinically important from not important
effects (see \code{\link{cidprop}}).}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect, can be abbreviated
(see \code{\link{cidprop}}).}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of class \code{"metacum"} with dedicated print and forest
functions.

The following list elements provide results from meta-analyses, each
adding one study at a time (see \code{\link{meta-object}} for more
information on these list elements):
\tabular{l}{
\cr
studlab, TE, seTE, df.random, lower, upper, statistic, pval, \cr
lower.predict, upper.predict, df.predict, w (sum of weights), \cr
tau2, se.tau2, lower.tau2, upper.tau2, tau, lower.tau, upper.tau, \cr
I2, lower.I2, upper.I2, Rb, n.harmonic.mean, t.harmonic.mean, \cr
k, k.study, k.all, k.TE, k.MH.
}

The following list elements contain results of the original meta-analysis:
\tabular{l}{
\cr
TE.pooled, seTE.pooled, df.random.pooled, \cr
lower.pooled, upper.pooled, statistic.pooled, pval.pooled, \cr
lower.predict.pooled, upper.predict.pooled, \cr
df.predict.pooled, w.pooled, \cr
tau2.pooled, se.tau2.pooled, lower.tau2.pooled, upper.tau2.pooled, \cr
tau.pooled, lower.tau.pooled, upper.tau.pooled, \cr
I2.pooled, lower.I2.pooled, upper.I2.pooled, Rb.pooled, \cr
n.harmonic.mean.pooled, t.harmonic.mean.pooled, \cr
k.pooled, k.study.pooled, k.all.pooled, k.TE.pooled, k.MH.pooled.
}
}
\description{
Performs a cumulative meta-analysis.
}
\details{
A cumulative meta-analysis is performed. Studies are included
sequentially as defined by \code{sortvar}.

Information from object \code{x} is utilised if argument
\code{pooled} is missing. A common effect model is assumed
(\code{pooled = "common"}) if argument \code{x$common} is
\code{TRUE}; a random effects model is assumed (\code{pooled =
"random"}) if argument \code{x$random} is \code{TRUE} and
\code{x$common} is \code{FALSE}.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac,
  data = Fleiss1993bin, studlab = study, sm = "RR", method = "I")
m1
metacum(m1)
metacum(m1, pooled = "random")

forest(metacum(m1))
forest(metacum(m1, pooled = "random"))

metacum(m1, sortvar = study)
metacum(m1, sortvar = 7:1)

m2 <- update(m1, title = "Fleiss1993bin meta-analysis", backtransf = FALSE)
metacum(m2)

data(Fleiss1993cont)
m3 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD")
metacum(m3)

}
\references{
Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation
}
\seealso{
\code{\link{forest.metacum}}, \code{\link{print.metacum}},
  \code{\link{cidprop}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
