% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_methods.R
\name{borda_count}
\alias{borda_count}
\title{Borda count}
\usage{
borda_count(R, v = NULL)
}
\arguments{
\item{R}{matrix with rankings}

\item{v}{vector of votes for each ranking}
}
\value{
Vector with aggregated ranking
}
\description{
Rank aggregation with the Borda count method
}
\examples{
m <- 10
n <- 5
R <- matrix( runif( m * n ), m, n )
v <- sample( 50:100, n )
r <- borda_count( R, v )
}
\author{
Pedro Guarderas
\email{pedro.felipe.guarderas@gmail.com}
}
