% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMaskSeurat.R
\name{generateMaskSeurat}
\alias{generateMaskSeurat}
\title{Generates mask from a Seurat object. Requires \code{SeuratObject} package.}
\usage{
generateMaskSeurat(
  object,
  reduction = NULL,
  group.by = NULL,
  gridSize = 200,
  expand = 0.005,
  minSize = 10
)
}
\arguments{
\item{object}{Seurat object}

\item{reduction}{character vector specifying which reduction to use
(default: \code{DefaultDimReduc(object)})}

\item{group.by}{character vector specifying which field to use for clusters
(default: \code{"ident"})}

\item{gridSize}{target width and height of the raster used internally}

\item{expand}{distance used to expand borders, represented as a fraction of sqrt(width*height). Default: 1/200.}

\item{minSize}{Groups of less than \code{minSize} points are ignored, unless it is the only group for a cluster}
}
\value{
data.table with points representing the mask borders.
Each individual border line corresponds to a single level of \code{group} column.
Cluster assignment is in \code{cluster} column.
}
\description{
Generates mask from a Seurat object. Requires \code{SeuratObject} package.
}
\examples{
# only run if Seurat is installed
if (require("Seurat")) {
    data("pbmc_small")
    maskTable <- generateMaskSeurat(pbmc_small)

    library(ggplot2)
    # not the best plot, see vignettes for better examples
    DimPlot(pbmc_small) +
        geom_path(data=maskTable, aes(x=tSNE_1, y=tSNE_2, group=group))
}
}
