% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_miss.R
\name{manip_miss}
\alias{manip_miss}
\alias{na_to_zero}
\alias{na_to_mean}
\title{Modifying missing tie data}
\usage{
na_to_zero(.data)

na_to_mean(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
A data object of the same class as the function was given.
}
\description{
These functions offer tools for imputing missing tie data.
Currently two options are available:
\itemize{
\item \code{na_to_zero()} replaces any missing values with zeros,
which are the modal value in sparse social networks.
\item \code{na_to_mean()} replaces missing values with the average non-missing value.
}
}
\examples{
missTest <- ison_adolescents \%>\% 
   add_tie_attribute("weight", c(1,NA,NA,1,1,1,NA,NA,1,1)) \%>\% 
   as_matrix
missTest
na_to_zero(missTest)
na_to_mean(missTest)
}
\references{
\subsection{On missing data}{

Krause, Robert, Mark Huisman, Christian Steglich, and Tom A.B. Snijders. 2020.
"Missing data in cross-sectional networks: An extensive comparison of missing data treatment methods".
\emph{Social Networks}, 62: 99-112.
\doi{10.1016/j.socnet.2020.02.004}
}
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_direction}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
