% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_dolphins}
\alias{ison_dolphins}
\title{One-mode, undirected network of frequent associations in a dolphin pod (Lusseau et al. 2003)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Doubtful Sound dolphins ---------------------------------------------------
#> # A labelled, undirected network of 62 dolphins and 159 frequent association
#> ties
#> 
#> -- Nodes
#> # A tibble: 62 x 1
#>   name      
#>   <chr>     
#> 1 Beak      
#> 2 Beescratch
#> 3 Bumper    
#> 4 CCL       
#> 5 Cross     
#> 6 DN16      
#> # i 56 more rows
#> 
#> -- Ties
#> # A tibble: 159 x 2
#>    from    to
#>   <int> <int>
#> 1     4     9
#> 2     6    10
#> 3     7    10
#> 4     1    11
#> 5     3    11
#> 6     6    14
#> # i 153 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_dolphins)
}
\description{
These data contain the frequent associations between the 62 dolphins of a
pod of dolphins living off Doubtful Sound, New Zealand.
Additional information can be found in the literature cited below.
}
\references{
Lusseau, David, K. Schneider, O. J. Boisseau, P. Haase, E. Slooten, and S. M. Dawson. 2003.
"The bottlenose dolphin community of Doubtful Sound features a large proportion of long-lasting associations",
\emph{Behavioral Ecology and Sociobiology} 54, 396-405.

Lusseau, David. 2003.
"The emergent properties of a dolphin social network",
\emph{Proc. R. Soc. London B} 270(S): S186-S188.
\doi{10.1098/rsbl.2003.0057}

Lusseau, David. 2007.
"Evidence for social role in a dolphin social network".
\emph{Evolutionary Ecology} 21: 357–366.
\doi{10.1007/s10682-006-9105-0}
}
\keyword{datasets}
