% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_proportion.R
\name{print.indirect_proportion}
\alias{print.indirect_proportion}
\title{Print an 'indirect_proportion'-Class
Object}
\usage{
\method{print}{indirect_proportion}(x, digits = 3, annotation = TRUE, ...)
}
\arguments{
\item{x}{An 'indirect_proportion'-class
object.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
additional information should be
printed. Default is \code{TRUE}.}

\item{...}{Optional arguments.
Not used.}
}
\value{
\code{x} is returned invisibly. Called for
its side effect.
}
\description{
Print the content of an
'indirect_proportion'-class object,
the output of \code{\link[=indirect_proportion]{indirect_proportion()}}.
}
\details{
The \code{print} method of the
\code{indirect_proportion}-class object,
which is produced by
\code{\link[=indirect_proportion]{indirect_proportion()}}. In addition
to the proportion of effect
mediated, it also prints additional
information such as the path for
which the proportion is computed,
and all indirect path(s) from the
x-variable to the y-variable.

To get the proportion as a scalar,
use the \code{coef} method of
\code{indirect_proportion} objects.
}
\examples{

library(lavaan)
dat <- data_med
head(dat)
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, fixed.x = FALSE)
out <- indirect_proportion(x = "x",
                           y = "y",
                           m = "m",
                           fit = fit)
out
print(out, digits = 5)


}
\seealso{
\code{\link[=indirect_proportion]{indirect_proportion()}}
}
