% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_functions.R
\name{export_for_gis}
\alias{export_for_gis}
\title{Export Results for GIS Applications}
\usage{
export_for_gis(
  results,
  output_dir = file.path(tempdir(), "gis_export"),
  formats = c("shapefile", "geojson")
)
}
\arguments{
\item{results}{Analysis results object}

\item{output_dir}{Output directory}

\item{formats}{Character vector of formats: "shapefile", "geojson", "kml", "gpkg"}
}
\value{
List of created files
}
\description{
Export spatial results in GIS-ready formats
}
\examples{
\donttest{
# Use tempdir to avoid polluting check directory
results <- run_builtin_analysis(scale = "county", year = 2016)
output_dir <- file.path(tempdir(), "gis_outputs")
gis_files <- export_for_gis(results, output_dir)
}
}
