% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_analysis_functions.R
\name{run_state_analysis}
\alias{run_state_analysis}
\title{Run State-Level Analysis}
\usage{
run_state_analysis(
  state,
  scale = "huc8",
  year = 2016,
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  output_dir = file.path(tempdir(), paste0("state_", tolower(state), "_results")),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{state}{Character. Two-letter state abbreviation (e.g., "OH", "TX")}

\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{year}{Numeric. Year to analyze}

\item{nutrients}{Character vector. Nutrients to analyze}

\item{include_wwtp}{Logical. Whether to include WWTP analysis}

\item{output_dir}{Character. Output directory}

\item{verbose}{Logical. Show progress messages}

\item{...}{Additional arguments passed to run_builtin_analysis}
}
\value{
List with analysis results for the state
}
\description{
Run manureshed analysis for a specific state
}
\examples{
\donttest{
# Use Texas which has more data
texas_results <- run_state_analysis(
  state = "TX",
  scale = "county",  # Use county for faster processing
  year = 2016,
  nutrients = "nitrogen",  # Single nutrient for speed
  include_wwtp = TRUE
)

# California county-level analysis
ca_results <- run_state_analysis(
  state = "CA",
  scale = "county",
  year = 2010,
  nutrients = "nitrogen"
)
}
}
