% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengths_linter.R
\name{lengths_linter}
\alias{lengths_linter}
\title{Require usage of \code{lengths()} where possible}
\usage{
lengths_linter()
}
\description{
\code{\link[base:lengths]{base::lengths()}} is a function that was added to base R in version 3.2.0 to
get the length of each element of a list. It is equivalent to
\code{sapply(x, length)}, but faster and more readable.
}
\examples{
# will produce lints
lint(
  text = "sapply(x, length)",
  linters = lengths_linter()
)

lint(
  text = "vapply(x, length, integer(1L))",
  linters = lengths_linter()
)

lint(
  text = "purrr::map_int(x, length)",
  linters = lengths_linter()
)

# okay
lint(
  text = "lengths(x)",
  linters = lengths_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
