% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_file_linter.R
\name{download_file_linter}
\alias{download_file_linter}
\title{Recommend usage of a portable \code{mode} value for downloading files}
\usage{
download_file_linter()
}
\description{
\code{mode = "w"} (the default) or \code{mode = "a"} in \code{download.file()} can generate broken files
on Windows. Instead, \code{\link[utils:download.file]{utils::download.file()}} recommends the usage of \code{mode = "wb"}
and \code{mode = "ab"}.
If \code{method = "curl"} or \code{method = "wget"}, no \code{mode} should be provided as it will be ignored.
}
\examples{
# will produce lints
lint(
  text = "download.file(x = my_url)",
  linters = download_file_linter()
)

lint(
  text = "download.file(x = my_url, mode = 'w')",
  linters = download_file_linter()
)

lint(
  text = "download.file(x = my_url, method = 'curl', mode = 'wb')",
  linters = download_file_linter()
)

# okay
lint(
  text = "download.file(x = my_url, mode = 'wb')",
  linters = download_file_linter()
)

lint(
  text = "download.file(x = my_url, method = 'curl')",
  linters = download_file_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=common_mistakes_linters]{common_mistakes}, \link[=robustness_linters]{robustness}
}
