% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.R
\name{pvcalc}
\alias{pvcalc}
\title{Calculate prior variances from a matrix of prior genotype probabilities.}
\usage{
pvcalc(priormat)
}
\arguments{
\item{priormat}{A matrix of prior genotype probabilities. Element
\code{priormat[i, j]} is the prior probability of dosage \code{j}
at SNP \code{i}.}
}
\value{
A vector of prior variances.
}
\description{
Given a matrix of prior probabilities for the genotypes at each SNP,
this function will calculate the prior variance of genotypes.
}
\examples{
data("uit")
priormat <- uit$snpdf[, paste0("Pr_", 0:4)]
pvcalc(priormat)

}
\author{
David Gerard
}
