% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_s3.R
\docType{class}
\name{ldmppr_sim}
\alias{ldmppr_sim}
\alias{print.ldmppr_sim}
\alias{as.data.frame.ldmppr_sim}
\alias{nobs.ldmppr_sim}
\alias{plot.ldmppr_sim}
\alias{mpp.ldmppr_sim}
\title{Simulated marked point process object}
\usage{
\method{print}{ldmppr_sim}(x, ...)

\method{as.data.frame}{ldmppr_sim}(x, ...)

\method{nobs}{ldmppr_sim}(object, ...)

\method{plot}{ldmppr_sim}(x, pattern_type = "simulated", ...)

mpp.ldmppr_sim(x, ...)
}
\arguments{
\item{x}{a `ldmppr_sim` object.}

\item{...}{additional arguments (not used).}

\item{object}{a `ldmppr_sim` object.}

\item{pattern_type}{type of pattern to plot `"simulated"` (default).}
}
\value{
For methods:
\describe{
  \item{`print()`}{prints a summary of the simulation.}
  \item{`plot()`}{returns a ggplot visualization of the marked point pattern.}
  \item{`as.data.frame()`}{returns the simulated realization as a data.frame.}
  \item{`nobs()`}{returns the number of points in the realization.}
  \item{`mpp()`}{returns the marked point pattern object.}
}
}
\description{
`ldmppr_sim` objects are returned by [simulate_mpp()]. They contain the simulated
realization, an associated marked point pattern object, and metadata used to
reproduce or inspect the simulation.
}
\details{
An `ldmppr_sim` is a list with at least:
\itemize{
  \item `process`: process name (e.g. `"self_correcting"`)
  \item `mpp`: a marked point pattern object
  \item `realization`: data.frame with columns `time`, `x`, `y`, `marks`
  \item `params`, `bounds`, and other metadata
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_sim)}: Print a brief summary of the simulation.

\item \code{as.data.frame(ldmppr_sim)}: Coerce to a data.frame of the simulated realization.

\item \code{nobs(ldmppr_sim)}: Number of simulated points.

\item \code{plot(ldmppr_sim)}: Plot the simulated marked point pattern.

}}
\section{Functions}{
\itemize{
\item \code{mpp.ldmppr_sim()}: Extract the underlying marked point pattern object.

}}
