% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_modindices.R
\name{nice_modindices}
\alias{nice_modindices}
\title{Extract relevant modification indices along item labels}
\usage{
nice_modindices(fit, labels = NULL, method = "lcs", sort = TRUE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract modification indices from}

\item{labels}{Dataframe of labels. If the original data
frame is provided, and that it contains labelled
variables, will automatically attempt to extract
the correct labels from the dataframe.}

\item{method}{Method for distance calculation from
\link[stringdist:stringsim]{stringdist::stringsim}. Defaults to \code{"lcs"}.}

\item{sort}{Logical. If TRUE, sort the output using the values of
the modification index values. Higher values appear first.
Defaults to \code{TRUE}.}

\item{...}{Arguments to be passed to \link[lavaan:modificationIndices]{lavaan::modindices}}
}
\value{
A dataframe, including the outcome ("lhs"), predictor ("rhs"),
standardized regression coefficient ("std.all"), corresponding
p-value, as well as the unstandardized regression coefficient
("est") and its confidence interval ("ci.lower", "ci.upper").
}
\description{
Extract relevant modification indices along item labels,
with a similarity score provided to help guide decision-making
for removing redundant items with high covariance.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE) && requireNamespace("sjlabelled", quietly = TRUE) && requireNamespace("stringdist", quietly = TRUE)) withAutoprint(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(regression <- list(
  ageyr = c("visual", "textual", "speed"),
  grade = c("visual", "textual", "speed")
))

HS.model <- write_lavaan(latent = latent, regression = regression)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
nice_modindices(fit, maximum.number = 5)
data_labels <- data.frame(
  x1 = "I have good visual perception",
  x2 = "I have good cube perception",
  x3 = "I have good at lozenge perception",
  x4 = "I have paragraph comprehension",
  x5 = "I am good at sentence completion",
  x6 = "I excel at finding the meaning of words",
  x7 = "I am quick at doing mental additions",
  x8 = "I am quick at counting dots",
  x9 = "I am quick at discriminating straight and curved capitals"
)
nice_modindices(fit, maximum.number = 10, labels = data_labels, op = "~~")

x <- HolzingerSwineford1939
x <- sjlabelled::set_label(x, label = c(rep("", 6), data_labels))
fit <- sem(HS.model, data = x)
nice_modindices(fit, maximum.number = 10, op = "~~")
\dontshow{\}) # examplesIf}
}
