% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{keras_objects}
\alias{keras_objects}
\alias{keras_optimizers}
\alias{keras_losses}
\alias{keras_metrics}
\title{Dynamically Discovered Keras Objects}
\format{
An object of class \code{character} of length 12.

An object of class \code{character} of length 21.

An object of class \code{character} of length 32.
}
\usage{
keras_optimizers

keras_losses

keras_metrics
}
\description{
These exported vectors contain the names of optimizers, losses, and metrics
discovered from the installed \code{keras3} package when \code{kerasnip} is loaded.
This ensures that \code{kerasnip} is always up-to-date with your Keras version.
}
\details{
These objects are primarily used to provide the default \code{values} for the \code{dials}
parameter functions, \code{\link[=optimizer_function]{optimizer_function()}} and \code{\link[=loss_function_keras]{loss_function_keras()}}. This
allows for tab-completion in IDEs and validation of optimizer and loss names
when tuning models.

The discovery process in \code{.onLoad()} scrapes the \code{keras3} namespace for
functions matching \verb{optimizer_*}, \verb{loss_*}, and \verb{metric_*} patterns.
}
\keyword{datasets}
\keyword{internal}
