% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_keras_grid.R
\name{inform_errors}
\alias{inform_errors}
\title{Inform About Compilation Errors}
\usage{
inform_errors(compiled_grid, n = 10)
}
\arguments{
\item{compiled_grid}{A tibble, the result of a call to \code{compile_keras_grid()}.}

\item{n}{A single integer for the maximum number of distinct errors to
display in detail.}
}
\value{
Invisibly returns the input \code{compiled_grid}. Called for its side
effect of printing a summary to the console.
}
\description{
This helper function inspects the results from \code{compile_keras_grid()} and
prints a formatted, easy-to-read summary of any compilation errors that
occurred.
}
\details{
Display a Summary of Compilation Errors

This is most useful for interactive debugging of complex tuning grids where
some hyperparameter combinations may lead to invalid Keras models.
}
\examples{
\donttest{
if (requireNamespace("keras3", quietly = TRUE)) {
  library(keras3)
  library(parsnip)
  library(dials)

  # 1. Define layer blocks
  input_block <- function(model, input_shape) {
    keras_model_sequential(input_shape = input_shape)
  }
  hidden_block <- function(model, units = 32) {
    model |> layer_dense(units = units, activation = "relu")
  }
  output_block <- function(model, num_classes) {
    model |> layer_dense(units = num_classes, activation = "softmax")
  }

  # 2. Define a kerasnip model specification
  create_keras_sequential_spec(
    model_name = "my_mlp_grid_3",
    layer_blocks = list(
      input = input_block,
      hidden = hidden_block,
      output = output_block
    ),
    mode = "classification"
  )

  mlp_spec <- my_mlp_grid_3(
    hidden_units = tune(),
    compile_loss = "categorical_crossentropy",
    compile_optimizer = "adam"
  )

  # 3. Create a hyperparameter grid
  param_grid <- tibble::tibble(
    hidden_units = c(32, 64, -10)
  )

  # 4. Prepare dummy data
  x_train <- matrix(rnorm(100 * 10), ncol = 10)
  y_train <- factor(sample(0:1, 100, replace = TRUE))

  # 5. Compile models over the grid
  compiled_grid <- compile_keras_grid(
    spec = mlp_spec,
    grid = param_grid,
    x = x_train,
    y = y_train
  )

  # 6. Inform about errors
  inform_errors(compiled_grid)
  remove_keras_spec("my_mlp_grid_3")
}
}
}
