% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{LabeljsCox}
\alias{LabeljsCox}
\title{LabeljsCox: Apply label information to cox2.display object using label data}
\usage{
LabeljsCox(obj, ref)
}
\arguments{
\item{obj}{cox2.display object}

\item{ref}{Label data made by mk.lev function}
}
\value{
cox2.display object with label information
}
\description{
Apply label information to cox2.display object using label data
}
\details{
DETAILS
}
\examples{
library(survival)
fit <- coxph(Surv(time, status) ~ sex + ph.ecog + ph.karno + cluster(inst),
  data = lung, model = TRUE
)
fit.table <- cox2.display(fit)
lung.label <- mk.lev(lung)
LabeljsCox(fit.table, ref = lung.label)
}
