% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_check.R
\name{key_duplicates}
\alias{key_duplicates}
\title{Find Duplicate Keys}
\usage{
key_duplicates(data, by, keep = c("all", "first", "last"))
}
\arguments{
\item{data}{A data frame.}

\item{by}{A character vector of column names to check for duplicates.}

\item{keep}{Character. Which duplicates to return:
\describe{
\item{"all"}{Return all rows with duplicated keys (default)}
\item{"first"}{Return only the first occurrence of each duplicate}
\item{"last"}{Return only the last occurrence of each duplicate}
}}
}
\value{
A data frame containing the duplicated rows, with an additional
column \code{.n_duplicates} showing how many times each key appears.
Returns an empty data frame (0 rows) if no duplicates found.
}
\description{
Identifies rows with duplicate values in the specified key columns.
Returns a data frame containing only the rows with duplicated keys,
along with a count of occurrences.
}
\examples{
df <- data.frame(
  id = c(1, 2, 2, 3, 3, 3, 4),
  value = letters[1:7]
)

# Find all duplicates
key_duplicates(df, by = "id")

# Find first occurrence only
key_duplicates(df, by = "id", keep = "first")

}
\seealso{
\code{\link[=key_check]{key_check()}}, \code{\link[=join_spy]{join_spy()}}
}
