% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_strict.R
\name{join_strict}
\alias{join_strict}
\title{Strict Join with Cardinality Enforcement}
\usage{
join_strict(
  x,
  y,
  by,
  type = c("left", "right", "inner", "full"),
  expect = c("1:1", "1:m", "1:many", "m:1", "many:1", "m:m", "many:many"),
  ...
)
}
\arguments{
\item{x}{A data frame (left table).}

\item{y}{A data frame (right table).}

\item{by}{A character vector of column names to join by.}

\item{type}{Character. The type of join to perform. One of \code{"left"} (default),
\code{"right"}, \code{"inner"}, \code{"full"}.}

\item{expect}{Character. The expected cardinality relationship. One of:
\describe{
\item{"1:1"}{Each key in x matches at most one key in y, and vice versa}
\item{"1:m" or "1:many"}{Each key in x can match multiple keys in y,
but each key in y matches at most one key in x}
\item{"m:1" or "many:1"}{Each key in y can match multiple keys in x,
but each key in x matches at most one key in y}
\item{"m:m" or "many:many"}{No cardinality constraints (allows all relationships)}
}}

\item{...}{Additional arguments passed to the underlying join function.}
}
\value{
The joined data frame if the cardinality constraint is satisfied.
Throws an error if the constraint is violated.
}
\description{
Performs a join operation that fails if the specified cardinality constraint
is violated. Use this to catch unexpected many-to-many relationships early.
}
\examples{
orders <- data.frame(id = 1:3, product = c("A", "B", "C"))
customers <- data.frame(id = 1:3, name = c("Alice", "Bob", "Carol"))

# This succeeds (1:1 relationship)
join_strict(orders, customers, by = "id", expect = "1:1")

# This fails if customers had duplicate ids (wrapped in try to show error)
customers_dup <- data.frame(id = c(1, 1, 2), name = c("A1", "A2", "B"))
try(join_strict(orders, customers_dup, by = "id", expect = "1:1"))

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=left_join_spy]{left_join_spy()}}
}
