% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_twonn.R
\name{autoplot.twonn_bayes}
\alias{autoplot.twonn_bayes}
\title{Plot the output of the \code{TWO-NN} model estimated via the Bayesian
approach}
\usage{
\method{autoplot}{twonn_bayes}(
  object,
  plot_low = 0,
  plot_upp = NULL,
  by = 0.05,
  title = "Bayesian TWO-NN",
  ...
)
}
\arguments{
\item{object}{object of class \code{twonn_bayes}, the output of the
\code{twonn} function when \code{method = "bayes"}.}

\item{plot_low}{lower bound of the interval on which the posterior density
is plotted.}

\item{plot_upp}{upper bound of the interval on which the posterior density
is plotted.}

\item{by}{step-size at which the sequence spanning the interval is
incremented.}

\item{title}{character string used as title of the plot.}

\item{...}{other arguments passed to specific methods.}
}
\value{
\code{\link[ggplot2]{ggplot2}} object displaying the posterior
distribution of the intrinsic dimension parameter.
}
\description{
Use this method without the \code{.twonn_bayes} suffix.
The function returns the density plot of the
posterior distribution computed with the \code{bayes} method.
}
\seealso{
\code{\link{twonn}}

Other autoplot methods: 
\code{\link{autoplot.Hidalgo}()},
\code{\link{autoplot.gride_bayes}()},
\code{\link{autoplot.twonn_linfit}()},
\code{\link{autoplot.twonn_mle}()}
}
\concept{autoplot methods}
