% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_census.r
\name{get_census}
\alias{get_census}
\title{Fetch 2021 Census data from the ineAtlas data repository}
\usage{
get_census(level, cache = TRUE, cache_dir = tempdir())
}
\arguments{
\item{level}{Character string specifying the geographic level. Must be one of:
"municipality", "district", or "tract"}

\item{cache}{Logical indicating whether to cache the extracted data. Default is TRUE.
Cached data is stored uncompressed for faster access.}

\item{cache_dir}{Character string specifying the cache directory. Default is tempdir().}
}
\value{
A tibble containing the requested census data at the specified geographic level.
The data includes demographic, socioeconomic and housing indicators from the 2021
Population and Housing Census. The data is automatically extracted from compressed
files and cached locally if requested.
}
\description{
Downloads and extracts compressed census data files from the ineAtlas data repository,
providing access to detailed demographic, socioeconomic and housing indicators at
different geographic levels from the 2021 Population and Housing Census.
}
\note{
Data files are stored compressed on the repository to reduce size and
download times. The function handles decompression automatically. Census data
is only available for 2021.
}
\examples{
\donttest{
# Get municipality level census data
mun_data <- get_census("municipality")

# Get district level census data without caching
dist_data <- get_census("district", cache = FALSE)

# Get census tract level data
tract_data <- get_census("tract")
}

}
