% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifact.R
\name{artifact}
\alias{artifact}
\title{Make an Artifact File Entry}
\usage{
artifact(path, type = c("adhoc", "FLStock", "SAG"), ..., check = TRUE,
  quiet = FALSE)
}
\arguments{
\item{path}{The relative path to a file to be added, e.g. "data/indices.csv".}

\item{type}{the type of output, e.g. FLStock, SAG_upload}

\item{...}{a list of metadata to be attributed to the entry.}

\item{check}{logical, should the artifact be checked for validity?}

\item{quiet}{logical, should the function be quiet?}
}
\description{
Form and validate an artifact as an export from a TAF repository.
}
\examples{

sag_file <- system.file("SAG", "sol_27_4.xml", package = "icesTAF")
sag <- artifact(sag_file, type = "SAG", check = FALSE)
sag

\dontrun{
# to check the artifact, use:
sag <- artifact(tmpfile, type = "SAG")
# or
check.artifact(sag)
}

}
\seealso{
\link{check.artifact}
\link{write.artifacts}
}
