% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_read_features.R
\name{ifcb_read_features}
\alias{ifcb_read_features}
\title{Read Feature Files from a Specified Folder or File Paths}
\usage{
ifcb_read_features(feature_files = NULL, multiblob = FALSE, verbose = TRUE)
}
\arguments{
\item{feature_files}{A path to a folder containing feature files or a character vector of file paths.}

\item{multiblob}{Logical indicating whether to filter for multiblob files (default: FALSE).}

\item{verbose}{Logical. Whether to display progress information. Default is TRUE.}
}
\value{
A named list of data frames, where each element corresponds to a feature file read from \code{feature_files}.
The list is named with the base names of the feature files.
}
\description{
This function reads feature files from a given folder or a specified set of file paths,
optionally filtering them based on whether they are multiblob or single blob files.
}
\examples{
\dontrun{
# Read feature files from a folder
features <- ifcb_read_features("path/to/feature_folder")

# Read only multiblob feature files
multiblob_features <- ifcb_read_features("path/to/feature_folder", multiblob = TRUE)

# Read feature files from a list of file paths
features <- ifcb_read_features(c("path/to/file1.csv", "path/to/file2.csv"))
}

}
