% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_dermal_pbtk.R
\name{parameterize_dermal_pbtk}
\alias{parameterize_dermal_pbtk}
\title{Parameterizea generic PBTK model with dermal exposure}
\usage{
parameterize_dermal_pbtk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  model.type = "dermal_1subcomp",
  method.permeability = "UK-Surrey",
  species = "Human",
  default.to.human = FALSE,
  tissuelist = list(liver = c("liver"), kidney = c("kidney"), lung = c("lung"), gut =
    c("gut"), skin = c("skin")),
  force.human.clint.fup = FALSE,
  clint.pvalue.threshold = 0.05,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  regression = TRUE,
  suppress.messages = FALSE,
  restrictive.clearance = TRUE,
  minimum.Funbound.plasma = 1e-04,
  skin_depth = 0.12,
  skin.pH = 7,
  BW = NULL,
  height = 175,
  totalSA = NULL,
  Kvehicle2water = "water",
  InfiniteDose = 0,
  million.cells.per.gliver = 110,
  liver.density = 1.05,
  kgutabs = 2.18,
  Caco2.options = NULL
)
}
\arguments{
\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified. 
Parameters include 
tissue:plasma partition coefficients, organ volumes, and flows 
for the tissue lumping scheme specified by argument tissuelist.
Tissure:(fraction unbound in) plasma partitition coefficients are predicted
via Schmitt (2008)'s method as modified by Pearce et al. (2017) using
\code{\link{predict_partitioning_schmitt}}. Organ volumes and flows are
retrieved from table \code{\link{physiology.data}}.
Tissues must be described in table \code{\link{tissue.data}}. 

By default, this function initializes the parameters needed in the functions 
\code{\link{solve_pbtk}}, \code{\link{calc_css}}, and others using the httk 
default generic PBTK model (for oral and intravenous dosing only).

The default PBTK model includes an explicit first pass of the chemical through
the liver before it becomes available to systemic blood. We model systemic oral bioavailability as 
\ifelse{html}{\out{F<sub>bio</sub>=F<sub>abs</sub>*F<sub>gut</sub>*F<sub>hep</sub>}}{\eqn{F_{bio}=F_{abs}*F_{gut}*F_{hep}}}.
Only if \ifelse{html}{\out{F<sub>bio</sub>}}{\eqn{F_{bio}}}
has been measured in vivo and is found in
table \code{\link{chem.physical_and_invitro.data}} then we set 
\ifelse{html}{\out{F<sub>abs</sub>*F<sub>gut</sub>}}{\eqn{F_{abs}*F_{gut}}} 
to the measured value divided by 
\ifelse{html}{\out{F<sub>hep</sub>}}{\eqn{F_{hep}}} 
where \ifelse{html}{\out{F<sub>hep</sub>}}{\eqn{F_{hep}}}
is estimated from in vitro TK data using 
\code{\link{calc_hep_bioavailability}}.
If Caco2 membrane permeability data or predictions
are available \ifelse{html}{\out{F<sub>abs</sub>}}{\eqn{F_{abs}}} is estimated
using \code{\link{calc_fabs.oral}}.
Intrinsic hepatic metabolism is used to very roughly estimate
\ifelse{html}{\out{F<sub>gut</sub>}}{\eqn{F_{gut}}}
using \code{\link{calc_fgut.oral}}.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs.}

\item{model.type}{Choice of dermal model, either the default "dermal_1subcomp" for
the model with 1 compartment for the skin; or (not usable yet) "dermal" for the 
model with 2 sub compartments (a sc and ed layer) for skin which defaults 
to the sc layer being the stratum corneum and the ed layer being the combined
viable epidermis and dermis.}

\item{method.permeability}{For "dermal_1subcomp" model, method of calculating 
the permeability coefficient, P, either "Potts-Guy" or "UK-Surrey". 
Default is "UK-Surrey" (Sawyer et al., 2016 and Chen et al., 2015), which uses Fick's
law of diffusion to calculate P. For "dermal" model, this parameter is ignored.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{tissuelist}{Specifies compartment names and tissues groupings.
Remaining tissues in tissue.data are lumped in the rest of the body.
However, \code{\link{solve_dermal_pbtk}} only works with the default parameters.}

\item{force.human.clint.fup}{Forces use of human values for hepatic
intrinsic clearance and fraction of unbound plasma if true.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{restrictive.clearance}{In calculating hepatic.bioavailability, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{skin_depth}{skin_depth of skin, cm, used in calculating P.}

\item{skin.pH}{pH of dermis/skin, used in calculating P and Kskin2vehicle.}

\item{BW}{Body weight (kg)}

\item{height}{Height in cm, used in calculating totalSA.}

\item{totalSA}{Total body surface area (cm^2)}

\item{Kvehicle2water}{Partition coefficient for the vehicle (sometimes called the 
vehicle) carrying the chemical to water. Default is "water", which assumes the vehicle is water.
Other optional inputs are "octanol", "olive oil", or a numeric value.}

\item{InfiniteDose}{If TRUE, we assume infinite dosing (i.e., a constant unchanging concentration
of chemical in the vehicle is considered) and Cvehicle is a constant. If
FALSE (default), dosing is finite and Cvehicle changes over time.}

\item{million.cells.per.gliver}{Hepatocellularity (defaults to 110 10^6 cells/g-liver, from Carlile et al. (1997))}

\item{liver.density}{Liver density (defaults to 1.05 g/mL from International Commission on Radiological Protection (1975))}

\item{kgutabs}{Oral absorption rate from gut (defaults to 2.18 1/h from Wambaugh et al. (2018))}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.default = 2,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.}
}
\value{
\item{BW}{Body Weight, kg.} 
\item{Clmetabolismc}{Hepatic Clearance, L/h/kg BW.} 
\item{Fgutabs}{Fraction of the oral dose absorbed, i.e. the fraction of
the dose that enters the gutlumen.} 
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte 
assay using the method of Kilford et al.(2008)} 
\item{Fskin_depth_sc}{Fraction of skin depth in strateum corneum so that the depth
of the SC is Fskin_depth_sc*skin_depth. This parameter does not appear when 
model.type="dermal_1subcomp".} 
\item{Fskin_depth_ed}{Fraction of skin depth in combined viable epidermis and
dermis so that the depth of the ED is Fskin_depth_ed*skin_depth. This parameter does not appear when 
model.type="dermal_1subcomp".} 
\item{Fskin_exposed}{Fraction of skin exposed.} 
\item{Funbound.plasma}{Fraction of plasma that is not bound.} 
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{InfiniteDose}{If InfiniteDose=1, infinite dosing is assumed and Cvehicle_infinite
is used in place of Cvehicle; if InfiniteDose=0, finite dosing is assumed and
Avehicle is used for dosing. When InfiniteDose=1, the state variable Avehicle 
does not have meaning.}
\item{Kblood2air}{Ratio of concentration of chemical in blood to air, calculated
using calc_kair.}
\item{Kgut2pu}{Ratio of concentration of chemical in gut tissue to unbound
concentration in plasma.} 
\item{kgutabs}{Rate that chemical enters the gut from gutlumen, 1/h.} 
\item{Kkidney2pu}{Ratio of concentration of chemical in
kidney tissue to unbound concentration in plasma.} 
\item{Kliver2pu}{Ratio of concentration of chemical in liver tissue to unbound 
concentration in plasma.} 
\item{Klung2pu}{Ratio of concentration of chemical in lung tissue
to unbound concentration in plasma.} 
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells to unbound 
concentration in plasma.}
\item{Krest2pu}{Ratio of concentration of chemical in rest of body tissue to
unbound concentration in plasma.} 
\item{Kskin2pu}{Ratio of concentration of chemical in skin tissue to
unbound concentration in plasma.}
\item{Kskin2vehicle}{Partition coefficient between exposed skin and vehicle. 
This parameter only appears when model.type="dermal_1subcomp"
and is replaced by Ksc2vehicle when model.type="dermal".} 
\item{Ksc2vehicle}{Partition coefficient between SC and vehicle. This parameter 
does not appear when model.type="dermal_1subcomp".} 
\item{Ksc2ed}{Partition coefficient between ED and
SC. This parameter does not appear when model.type="dermal_1subcomp".} 
\item{MA}{?}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.} 
\item{MW}{Molecular Weight, g/mol.} 
\item{P}{Permeability of the skin, cm/h. When model.type="dermal_1subcomp", 
this parameter changes depending on method.permeability. When model.type="dermal",
this parameter is replaced by Pvehicle2sc and Psc2ed.} 
\item{Pvehicle2sc}{Permeability
of the stratum corneum (SC), cm/h. This parameter does not appear when 
model.type="dermal_1subcomp".} 
\item{Psc2ed}{Permeability of the combined viable epidermis and dermis layer of the skin ("ed"), cm/h.
This parameter does not appear when model.type="dermal_1subcomp".} 
\item{Qalvc}{Unscaled alveolar ventilation rate, L/h/kg BW^3/4.}
\item{Qcardiacc}{Cardiac Output, L/h/kg BW^3/4.} 
\item{Qgfrc}{Glomerular Filtration Rate, L/h/kg BW^3/4, volume of fluid filtered 
from kidney and excreted.} 
\item{Qgutf}{Fraction of cardiac output flowing to the gut.}
\item{Qkidneyf}{Fraction of cardiac output flowing to the kidneys.}
\item{Qliverf}{Fraction of cardiac output flowing to the liver.}
\item{Qlungf}{Fraction of cardiac output flowing to the lung.}
\item{Qskinf}{Fraction of cardiac output flowing to the skin, or to the ed
layer of the skin when model.type="dermal".}
\item{Rblood2plasma}{The ratio of the concentration of the chemical in the
blood to the concentration in the plasma from available_rblood2plasma.}
\item{skin_depth}{Skin depth, cm.}
\item{totalSA}{Total body surface area, cm^2.} 
\item{Vartc}{Volume of the arteries per kg body weight, L/kg BW.}
\item{Vgutc}{Volume of the gut per kg body weight, L/kg BW.}
\item{Vkidneyc}{Volume of the kidneys per kg body weight, L/kg BW.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{Vlungc}{Volume of the lungs per kg body weight, L/kg BW.}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
\item{Vvenc}{Volume of the veins per kg body weight, L/kg BW.}
\item{Vskinc}{Volume of the skin per kg body weight, L/kg BW.}
\item{Vskin_scc}{Volume of the sc or upper layer of the skin per 
kg body weight, L/kg BW. This parameter does not appear when 
model.type="dermal_1subcomp".}
\item{Vskin_edc}{Volume of the combined viable epidermis and dermis layer of the skin per 
kg body weight, L/kg BW. This parameter does not appear when model.type="dermal_1subcomp".}
}
\description{
This function initializes the parameters needed in the functions solve_dermal_pbtk.
}
\examples{

\donttest{
params <- parameterize_dermal_pbtk(chem.cas="80-05-7")

params <- parameterize_dermal_pbtk(chem.cas="80-05-7", model.type="dermal_1subcomp", 
method.permeability="Potts-Guy")

params <- parameterize_dermal_pbtk(chem.cas="80-05-7", model.type="dermal", 
Kvehicle2water = "octanol")
}

}
\references{
Chen, L., Han, L., Saib, O. and Lian, G. (2015). In Silico Prediction of Percutaneous
Absorption and Disposition Kinetics of Chemicals. Pharmaceutical Research 32, 1779-93, 10.1007/s11095-014-1575-0

\insertRef{kilford2008hepatocellular}{httk}

Potts, R. O., Guy, R. H. (1992). Predicting skin permeability. Pharmaceutical 
research 9(5), 663-9, 10.1002/ajim.4700230505.

Sawyer, M. E., Evans, M. V., Wilson, C. A., Beesley, L. J., Leon, L. S., Eklund, 
C. R., Croom, E. L., Pegram, R. A. (2016). Development of a human physiologically 
based pharmacokinetic (PBPK) model for dermal permeability for lindane. Toxicology
Letters 245, 106-9, 10.1016/j.toxlet.2016.01.008
}
\seealso{
\code{\link{solve_dermal_pbtk}}

\code{\link{predict_partitioning_schmitt}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
Annabel Meade, John Wambaugh, and Robert Pearce
}
\keyword{Parameter}
\keyword{dermal}
\keyword{intravenous}
\keyword{oral}
\keyword{pbtk}
