% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_idiosyncratic.R
\name{get_p_value}
\alias{get_p_value}
\title{get p-value along with uncertainty on p-value}
\usage{
get_p_value(tst)
}
\arguments{
\item{tst}{A FRTCI.test object from detect_idiosyncratic()}
}
\value{
p-value and range of p-values due to monte carlo error.
}
\description{
Give confidence bounds (from monte carlo simulation error) for the p-values returned by a test
}
\examples{
Z <- rep(c(0, 1), 100)
tau <- 4
Y <- ifelse(Z, rnorm(100, tau), rnorm(100, 0))
df <- data.frame(Y=Y, Z=Z)
tst <- detect_idiosyncratic(Y ~ Z, df, B = 50, grid.size = 50)
get_p_value( tst )

}
