% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{get_labels}
\alias{get_labels}
\title{Get value labels}
\usage{
get_labels(
  object,
  strategy = "strategy_name",
  grp = "grp_name",
  state = "state_name",
  transition = "transition_name",
  death_label = "Death"
)
}
\arguments{
\item{object}{An object of class \code{hesim_data} created with \code{\link[=hesim_data]{hesim_data()}}.}

\item{strategy}{The name of the column in the \code{strategy} element of \code{object}
containing labels for \code{strategy_id}.}

\item{grp}{The name of the column in the \code{patient} element of \code{object}
containing labels for \code{grp_id}.}

\item{state}{The name of the column in the \code{state} element of \code{object}
containing labels for \code{state_id}.}

\item{transition}{The name of the column in the \code{transition} element of \code{object}
containing labels for \code{transition_id}.}

\item{death_label}{The label to use for the death health state. By default a
label named "Death" will be concatenated to the labels for the non-death health
states. The death state can be omitted from labels for the health states by setting
\code{death_label = NULL}.}
}
\value{
A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the names
are the labels. The names of the list are the names of the ID variables.
}
\description{
Get value labels for the ID variables in a \code{hesim_data} object and create a list
of named vectors that can be passed to formatting and plotting functions. This
lets users create nice labels for treatment strategies, subgroups, health states,
and/or transitions when presenting results.
}
\examples{
library("data.table")
strategies <- data.table(
  strategy_id = c(1, 2),
  strategy_name = c("Strategy 1", "Strategy 2")
)
patients <- data.table(
  patient_id = seq(1, 4),
  age = c(50, 55, 60, 65),
  grp_id = c(1, 1, 2, 2),
  grp_name = rep(c("Age 50-59", "Age 60-69"), each = 2)
)
states <- data.table(
  state_id =  seq(1, 2),
  state_name = c("State 1", "State 2")
)
hesim_dat <- hesim_data(
  strategies = strategies,
  patients = patients,
  states = states
)
labs <- get_labels(hesim_dat)
labs

# Pass to set_labels()
d <- data.table(strategy_id = c(1, 1, 2, 2),
                grp_id = c(1, 2, 1, 2))
set_labels(d, labs, new_name = c("strategy_name", "grp_name"))
d
}
\seealso{
\code{\link[=hesim_data]{hesim_data()}}, \code{\link[=set_labels]{set_labels()}}
}
