% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{onc3}
\alias{onc3}
\title{Multi-state oncology data for 3-state model}
\format{
A \code{data.table} with the following columns:
\describe{
\item{from}{Health state making a transition from.}
\item{to}{Health state making a transition to.}
\item{strategy_name}{Standard of care (SOC), new treatment 1 (New 1), or
new treatment 2 (New 2).}
\item{female}{1 if a patient is female; 0 if male.}
\item{age}{Patient age (in years).}
\item{patient_id}{Patient identification number.}
\item{time_start}{Starting time.}
\item{time_stop}{Stopping time.}
\item{status}{Status indicator: 1=transition, 0=censored.}
\item{transition_id}{Integer denoting transition: 1 = Stable -> Progression,
2 = Stable -> Death, 3 = Progression -> Death.}
\item{strategy_id}{Strategy identification number.}
\item{time}{Elapsed years between \code{time_start} and \code{time_stop}.}
}
}
\usage{
onc3
}
\description{
Simulated 3-state dataset in oncology with three health states
(Stable, Progression, and Death) and three possible transitions (Stable ->
Progression, Stable -> Death, and Progression -> Death).
}
\examples{
head(onc3)
}
\seealso{
\link{onc3p}
}
\keyword{datasets}
