% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_plot.R
\name{rankPlot}
\alias{rankPlot}
\title{Create a rank plot}
\usage{
rankPlot(
  df,
  title = NULL,
  summarize = TRUE,
  viridisPal = "turbo",
  xLab = "Item",
  yLab = "Rank count",
  legendTitle = "Rank",
  sigDigits = NULL,
  labelSize = 2.5,
  labelColor = "black",
  labelFace = c("plain", "bold", "italic", "bold-italic"),
  legendTextSize = 10,
  legendTitleSize = 10,
  axisTextSize = 12,
  axisTitleSize = 12,
  xAngle = 45,
  vJust = 0.6,
  labelScalingFactor = 0.9,
  labelOffset = 0.05,
  ...
)
}
\arguments{
\item{df}{A data frame with ranks as columns and items as rows, or a
summary data frame generated with \code{rankSummary}. If the latter,
\code{summarize} must be set to \code{FALSE}.}

\item{title}{Plot title.}

\item{summarize}{Whether to summarize the ranks with \code{rankSummary}.
Must be set to \code{FALSE} if the input data frame has been generated with
\code{rankSummary}.}

\item{viridisPal}{Viridis palette.}

\item{xLab}{Label of x axis.}

\item{yLab}{y axis label.}

\item{legendTitle}{Legend title.}

\item{sigDigits}{Number of significant digits used when displaying mean
ranks. If \code{NULL}, the mean ranks will not be displayed.}

\item{labelSize}{Size of label marking average rank for each item.
Ignored if \code{sigDigits} is \code{NULL}.}

\item{labelColor}{Color of label marking average rank for each item.
Ignored if \code{sigDigits} is \code{NULL}.}

\item{labelFace}{Font face of label marking average rank for each item. Must
be one among 'plain', 'bold', 'italic' and 'bold-italic'.
Ignored if \code{sigDigits} is \code{NULL}.}

\item{legendTextSize}{Legend text size.}

\item{legendTitleSize}{Legend title size.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{xAngle}{Angle of x axis text.}

\item{vJust}{Vertical justification in [0, 1].}

\item{labelScalingFactor}{Scaling factor used when displaying mean ranks.
Ignored if \code{sigDigits} is \code{NULL}.}

\item{labelOffset}{Vertical offset used when displaying mean ranks.
Ignored if \code{sigDigits} is \code{NULL}.}

\item{...}{Additional arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function creates a rank plot.
}
\examples{
df <- do.call(cbind, lapply(seq(30), function(i) sample(10, 10)))
rownames(df) <- paste0('M', seq(10))
colnames(df) <- paste0('R', seq(30))
rankPlot(df)

}
