/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Amodule.h" 
#define H5A_TESTING    

#include "H5private.h"   
#include "H5Apkg.h"      
#include "H5CXprivate.h" 
#include "H5Eprivate.h"  
#include "H5Iprivate.h"  
#include "H5SMprivate.h" 
#include "H5VLprivate.h" 

htri_t
H5A__is_shared_test(hid_t attr_id)
{
    H5A_t *attr;             
    htri_t ret_value = FAIL; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (attr = (H5A_t *)H5VL_object_verify(attr_id, H5I_ATTR)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not an attribute");

    
    ret_value = H5O_msg_is_shared(H5O_ATTR_ID, attr);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5A__get_shared_rc_test(hid_t attr_id, hsize_t *ref_count)
{
    H5A_t      *attr;                         
    H5CX_node_t api_ctx        = {{0}, NULL}; 
    bool        api_ctx_pushed = false;       
    herr_t      ret_value      = SUCCEED;     

    FUNC_ENTER_PACKAGE

    
    if (NULL == (attr = (H5A_t *)H5VL_object_verify(attr_id, H5I_ATTR)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not an attribute");

    
    if (H5CX_push(&api_ctx) < 0)
        HGOTO_ERROR(H5E_ATTR, H5E_CANTSET, FAIL, "can't set API context");
    api_ctx_pushed = true;

    
    assert(H5O_msg_is_shared(H5O_ATTR_ID, attr));

    
    if (H5SM_get_refcount(attr->oloc.file, H5O_ATTR_ID, &attr->sh_loc, ref_count) < 0)
        HGOTO_ERROR(H5E_ATTR, H5E_CANTGET, FAIL, "can't retrieve shared message ref count");

done:
    if (api_ctx_pushed && H5CX_pop(false) < 0)
        HDONE_ERROR(H5E_ATTR, H5E_CANTRESET, FAIL, "can't reset API context");

    FUNC_LEAVE_NOAPI(ret_value)
} 
