% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbs.R
\name{sbs.make.tree}
\alias{sbs.make.tree}
\title{Growing a binary tree for SBS algorithm}
\usage{
sbs.make.tree(input, tau = rep(1, nrow(input)), thr, trim, height)
}
\arguments{
\item{input}{input data matrix, with each row representing the component time series or their transformation}

\item{tau}{scaling terms the rows of \code{input}}

\item{thr, trim, height}{see \code{\link{sbs.alg}}}
}
\value{
S3 \code{bin.tree} object, which contains the following fields:
   \item{tree}{a \link{list} object containing information about the nodes at which change-points are detected}
   \item{mat}{matrix concatenation of the nodes of \code{tree}}
   \item{ecp}{estimated change-points}
   \item{thr}{threshold used to construct the tree}
}
\description{
Grow a binary tree via Sparsified Binary Segmentation
}
\keyword{internal}
