% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_codes_postaux.R
\name{get_apicarto_codes_postaux}
\alias{get_apicarto_codes_postaux}
\title{Apicarto Codes Postaux}
\usage{
get_apicarto_codes_postaux(code_post)
}
\arguments{
\item{code_post}{\code{character} corresponding to the postal code of a commune}
}
\value{
Object of class \code{data.frame}
}
\description{
Implementation of the "Codes Postaux" module from the
\href{https://apicarto.ign.fr/api/doc/codes-postaux}{IGN's apicarto}. This
API give information about commune from postal code.
}
\examples{
\dontrun{

info_commune <- get_apicarto_codes_postaux("29760")

code_post <- c("29760", "08170")
info_communes <- get_apicarto_codes_postaux(code_post)

code_post <- c("12345")
info_communes <- get_apicarto_codes_postaux(code_post)

code_post <- c("12345", "08170")
info_communes <- get_apicarto_codes_postaux(code_post)
}

}
