% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.tbl_uvregression.R
\name{inline_text.tbl_uvregression}
\alias{inline_text.tbl_uvregression}
\title{Report statistics from regression summary tables inline}
\usage{
\method{inline_text}{tbl_uvregression}(
  x,
  variable,
  level = NULL,
  pattern = "{estimate} ({conf.level*100}\% CI {conf.low}, {conf.high}; {p.value})",
  estimate_fun = x$inputs$estimate_fun,
  pvalue_fun = label_style_pvalue(prepend_p = TRUE),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_uvregression})\cr
Object created by \code{\link[=tbl_uvregression]{tbl_uvregression()}}}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single variable name of statistic to present}

\item{level}{(\code{string})\cr
Level of the variable to display for categorical variables.
Default is \code{NULL}}

\item{pattern}{(\code{string})\cr
String indicating the statistics to return.
Uses \code{\link[glue:glue]{glue::glue()}} formatting. Default is \code{NULL}}

\item{estimate_fun}{(\code{function})\cr
Function to style model coefficient estimates.
Columns \code{'estimate'}, \code{'conf.low'}, and \code{'conf.high'} are formatted.
Default is \code{x$inputs$estimate_fun}}

\item{pvalue_fun}{function to style p-values and/or q-values.
Default is \code{label_style_pvalue(prepend_p = TRUE)}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A string reporting results from a gtsummary table
}
\description{
Extracts and returns statistics from a table created by the \code{tbl_uvregression}
function for inline reporting in an R markdown document.
Detailed examples in the
\href{https://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\section{pattern argument}{

The following items (and more) are available to print.  Use \code{print(x$table_body)} to
print the table the estimates are extracted from.
\itemize{
\item \code{{estimate}} coefficient estimate formatted with 'estimate_fun'
\item \code{{conf.low}} lower limit of confidence interval formatted with 'estimate_fun'
\item \code{{conf.high}} upper limit of confidence interval formatted with 'estimate_fun'
\item \code{{p.value}} p-value formatted with 'pvalue_fun'
\item \code{{N}} number of observations in model
\item \code{{label}} variable/variable level label
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) withAutoprint(\{ # examplesIf}
inline_text_ex1 <-
  trial[c("response", "age", "grade")] \%>\%
  tbl_uvregression(
    method = glm,
    method.args = list(family = binomial),
    y = response,
    exponentiate = TRUE
  )

inline_text(inline_text_ex1, variable = age)
inline_text(inline_text_ex1, variable = grade, level = "III")
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
