% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{gaussian_fun}
\alias{gaussian_fun}
\title{Multivariate Gaussian linear model evaluation}
\usage{
gaussian_fun(N)
}
\arguments{
\item{N}{Number of input samples to generate.}
}
\value{
A list with two elements:
\itemize{
\item \code{x}: a numeric matrix of size \code{N x 8} containing the input samples.
\item \code{y}: a numeric vector of length \code{N} with the corresponding function outputs.
}
}
\description{
Generates samples from a multivariate Gaussian distribution and evaluates a simple
linear transformation model.
}
\details{
Inputs \code{x} are sampled from:
\deqn{
\mathbf{X} \sim \mathcal{N}(\boldsymbol{\mu}, \Sigma), \quad \boldsymbol{\mu} = [1, 1, 1], \quad \Sigma = \begin{bmatrix} 1 & 0.5 & 0.5 \\ 0.5 & 1 & 0.5 \\ 0.5 & 0.5 & 1 \end{bmatrix}
}

The output is given by:
\deqn{
\mathbf{Y} = A \mathbf{X}^{\top}, \quad A = \begin{bmatrix} 4 & -2 & 1 \\ 2 & 5 & -1 \end{bmatrix}
}
}
\examples{
result <- gaussian_fun(1000)
head(result$x)
head(result$y)

}
\seealso{
\code{\link{sobol_fun}}, \code{\link{ishi_homma_fun}}
}
