% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnorm.R
\name{dgnorm}
\alias{dgnorm}
\alias{pgnorm}
\alias{qgnorm}
\alias{rgnorm}
\title{The generalized normal distribution}
\source{
\code{dgnorm}, \code{pgnorm}, \code{qgnorm} and\code{rgnorm} are all
parametrized as in Version 1 of the
\href{https://en.wikipedia.org/wiki/Generalized_normal_distribution}{Generalized
Normal Distribution Wikipedia page},
which uses the parametrization given by in Nadarajah (2005).
The same distribution was described much earlier by Subbotin (1923) and named
the exponential power distribution by Box and Tiao (1973). \cr \cr
}
\usage{
dgnorm(q, mu = 0, scale = 1, shape = 1, log = FALSE)

pgnorm(q, mu = 0, scale = 1, shape = 1, lower.tail = TRUE,
  log.p = FALSE)

qgnorm(p, mu = 0, scale = 1, shape = 1, lower.tail = TRUE,
  log.p = FALSE)

rgnorm(n, mu = 0, scale = 1, shape = 1)
}
\arguments{
\item{q}{vector of quantiles}

\item{mu}{location parameter}

\item{scale}{scale parameter}

\item{shape}{shape parameter}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X\leq x]},
otherwise \eqn{P[X> x]}}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the Generalised Normal distribution with the location
mu, a scale and a shape parameters.
}
\details{
A generalized normal random variable \eqn{x} with parameters location \eqn{\mu},
scale \eqn{s > 0} and shape \eqn{\beta > 0} has density:

\deqn{p(x) = \beta exp{-(|x - \mu|/s)^\beta}/(2s \Gamma(1/\beta)).} \cr
The mean and variance of \eqn{x} are \eqn{\mu} and
\eqn{s^2 \Gamma(3/\beta)/\Gamma(1/\beta)}, respectively.

The function are based on the functions from gnorm package of Maryclare Griffin
(package has been abandoned since 2018).

The quantile and cumulative functions use uniform approximation for cases
\code{shape>100}. This is needed, because otherwise it is not possible to calculate
the values correctly due to \code{scale^(shape)=Inf} in R.
}
\examples{
# Density function values for standard normal distribution
x <- dgnorm(seq(-1, 1, length.out = 100), 0, sqrt(2), 2)
plot(x, type="l")

#CDF of standard Laplace
x <- pgnorm(c(-100:100), 0, 1, 1)
plot(x, type="l")

# Quantiles of S distribution
qgnorm(c(0.025,0.975), 0, 1, 0.5)

# Random numbers from a distribution with shape=10000 (approximately uniform)
x <- rgnorm(1000, 0, 1, 1000)
hist(x)

}
\references{
\itemize{
\item Box, G. E. P. and G. C. Tiao. "Bayesian inference in Statistical Analysis."
Addison-Wesley Pub. Co., Reading, Mass (1973).
\item Nadarajah, Saralees. "A generalized normal distribution." Journal of
Applied Statistics 32.7 (2005): 685-694.
\item Subbotin, M. T. "On the Law of Frequency of Error." Matematicheskii
Sbornik 31.2 (1923):  206-301.
}
}
\seealso{
\code{\link[greybox]{Distributions}}
}
\author{
Maryclare Griffin and Ivan Svetunkov
}
\keyword{distribution}
