% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_ask_enhanced.R
\name{goose_ask}
\alias{goose_ask}
\title{Enhanced Ask Goose with Formatting}
\usage{
goose_ask(
  prompt,
  format = getOption("goose.auto_format", TRUE),
  output_format = c("text", "json"),
  quiet = TRUE,
  timeout = 30,
  session_id = NULL,
  width = getOption("goose.format_width", 80),
  color = getOption("goose.format_color", TRUE),
  ...
)
}
\arguments{
\item{prompt}{Character string with the question or prompt}

\item{format}{Logical, whether to format the response (default TRUE)}

\item{output_format}{Character, either "text" or "json"}

\item{quiet}{Logical, suppress status messages}

\item{timeout}{Numeric, timeout in seconds (default 30)}

\item{session_id}{Optional session ID for context preservation}

\item{width}{Integer, line width for wrapping (default 80)}

\item{color}{Logical, whether to use color output (default TRUE)}

\item{...}{Additional formatting arguments}
}
\value{
If format=TRUE and output_format="text", displays formatted response and returns raw text invisibly.
If format=FALSE or output_format="json", returns the raw response.
}
\description{
Send a query to Goose AI and get a beautifully formatted response.
This is an enhanced version of goose_ask that formats the output by default.
}
\examples{
\dontrun{
# Get a beautifully formatted response (default)
goose_ask("What is the tidyverse?")

# Get raw unformatted response
raw <- goose_ask("What is R?", format = FALSE)

# Get JSON response (never formatted)
data <- goose_ask("List 5 R packages", output_format = "json")

# Customize formatting
goose_ask("Explain ggplot2", width = 100, color = FALSE)
}
}
