% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_read.R
\name{spread_sheet}
\alias{spread_sheet}
\title{Spread a data frame of cells into spreadsheet shape}
\usage{
spread_sheet(
  df,
  col_names = TRUE,
  col_types = NULL,
  na = "",
  trim_ws = TRUE,
  guess_max = min(1000, max(df$row)),
  .name_repair = "unique"
)
}
\arguments{
\item{df}{A data frame with one row per (nonempty) cell, integer variables
\code{row} and \code{column} (probably referring to location within the spreadsheet),
and a list-column \code{cell} of \code{SHEET_CELL} objects.}

\item{col_names}{\code{TRUE} to use the first row as column names, \code{FALSE} to get
default names, or a character vector to provide column names directly. If
user provides \code{col_types}, \code{col_names} can have one entry per column or one
entry per unskipped column.}

\item{col_types}{Column types. Either \code{NULL} to guess all from the
spreadsheet or a string of readr-style shortcodes, with one character or
code per column. If exactly one \code{col_type} is specified, it is recycled.
See Column Specification for more.}

\item{na}{Character vector of strings to interpret as missing values. By
default, blank cells are treated as missing data.}

\item{trim_ws}{Logical. Should leading and trailing whitespace be trimmed
from cell contents?}

\item{guess_max}{Maximum number of data rows to use for guessing column
types.}

\item{.name_repair}{Handling of column names. By default, googlesheets4
ensures column names are not empty and are unique. There is full support
for \code{.name_repair} as documented in \code{\link[tibble:tibble]{tibble::tibble()}}.}
}
\value{
A tibble in the shape of the original spreadsheet, but enforcing
user's wishes regarding column names, column types, \code{NA} strings, and
whitespace trimming.
}
\description{
Reshapes a data frame of cells (presumably the output of
\code{\link[=range_read_cells]{range_read_cells()}}) into another data frame, i.e., puts it back into the
shape of the source spreadsheet. This function exists primarily for internal
use and for testing. The flagship function \code{\link[=range_read]{range_read()}}, a.k.a.
\code{\link[=read_sheet]{read_sheet()}}, is what most users are looking for. It is basically
\code{\link[=range_read_cells]{range_read_cells()}} + \code{spread_sheet()}.
}
\examples{
\dontshow{if (gs4_has_token()) withAutoprint(\{ # examplesIf}
df <- gs4_example("mini-gap") \%>\%
  range_read_cells()
spread_sheet(df)

# ^^ gets same result as ...
read_sheet(gs4_example("mini-gap"))
\dontshow{\}) # examplesIf}
}
