test_that("Offline", {
  skip_on_cran()
  skip_if_gisco_offline()

  options(gisco_test_404 = TRUE)
  expect_message(
    n <- gisco_get_airports(update_cache = TRUE),
    "Error"
  )
  expect_null(n)

  options(gisco_test_404 = FALSE)
})

test_that("Get airports", {
  expect_error(gisco_get_airports(year = 2020))

  skip_on_cran()
  skip_if_gisco_offline()

  all <- expect_silent(gisco_get_airports())
  es <- expect_silent(gisco_get_airports(country = "ES"))
  expect_true(all(sf::st_geometry_type(all) == "POINT"))
  expect_s3_class(es, "tbl_df")
  expect_s3_class(es, "sf")
  expect_lt(nrow(es), nrow(all))
  expect_identical(
    sf::st_crs(all),
    sf::st_crs(4326)
  )

  expect_identical(
    sf::st_crs(es),
    sf::st_crs(4326)
  )

  expect_identical(as.character(unique(es$CNTR_CODE)), "ES")
  expect_true(nrow(all) > nrow(es))

  # 2006

  all <- expect_silent(gisco_get_airports(2006))
  expect_true(all(sf::st_geometry_type(all) == "POINT"))

  es <- expect_silent(gisco_get_airports(2006, country = "ES"))
  expect_s3_class(es, "tbl_df")
  expect_s3_class(es, "sf")
  expect_lt(nrow(es), nrow(all))
  expect_identical(
    sf::st_crs(all),
    sf::st_crs(4326)
  )

  expect_identical(
    sf::st_crs(es),
    sf::st_crs(4326)
  )

  expect_identical(as.character(unique(es$CNTR_CODE)), "ES")
  expect_true(nrow(all) > nrow(es))
})
