% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-units.R
\encoding{UTF-8}
\name{gisco_get_units}
\alias{gisco_get_units}
\title{Get geospatial units data from GISCO API}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}

All the source files are \code{.geojson} files.
}
\usage{
gisco_get_units(
  id_giscoR = c("nuts", "countries", "urban_audit"),
  unit = "ES4",
  mode = c("sf", "df"),
  year = 2016,
  epsg = 4326,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = 20,
  spatialtype = "RG"
)
}
\arguments{
\item{id_giscoR}{Select the \code{unit} type to be downloaded. Accepted values are
\code{"nuts"}, \code{"countries"} or \code{"urban_audit"}.}

\item{unit}{Unit ID to be downloaded.}

\item{mode}{Controls the output of the function. Possible values are \code{"sf"}
or \code{"df"}. See \strong{Value}.}

\item{year}{character string or number. Release year of the file.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{resolution}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}

\item{spatialtype}{character string. Type of geometry to be returned.
Options available are:
\itemize{
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
\item \code{"LB"}: Labels - \code{POINT} object.
}}
}
\value{
A \code{\link[sf:sf]{sf}} object on \code{mode = "sf"} or a \link[tibble:tbl_df-class]{tibble}
on \code{mode = "df"}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated. Use:
\itemize{
\item \code{\link[=gisco_get_metadata]{gisco_get_metadata()}} (equivalent to \code{mode = "df"}).
\item \code{\link[=gisco_get_unit]{?gisco_get_unit}}functions (equivalent to
\code{mode = "sf"})
}
}
\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# mode df
gisco_get_units("nuts", mode = "df", year = 2016)
# ->
gisco_get_metadata("nuts", year = 2016)

# mode sf for NUTS
gisco_get_units("nuts", unit = "ES111", mode = "sf", year = 2016)
# ->
gisco_get_unit_nuts(unit = "ES111", year = 2016)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_metadata]{gisco_get_metadata()}}, \code{\link[=gisco_get_unit]{?gisco_get_unit}} functions.
}
\concept{deprecated functions}
