% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-solid.R
\name{theme_solid}
\alias{theme_solid}
\title{Theme with nothing other than a background color}
\usage{
theme_solid(base_size = 12, base_family = "", fill = NA)
}
\arguments{
\item{base_size}{Base font size.}

\item{base_family}{Ignored, kept for consistency with \code{\link[ggplot2]{theme}()}.}

\item{fill}{Background color of the plot.}
}
\description{
Theme that removes all non-geom elements (lines, text, etc),
This theme is when only the geometric objects are desired.
}
\examples{
library("ggplot2")

ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  theme_solid(fill = "white")

ggplot(mtcars, aes(wt, mpg)) +
  geom_point(color = "white") +
  theme_solid(fill = "black")
}
\seealso{
Other themes: 
\code{\link{theme_base}()},
\code{\link{theme_clean}()},
\code{\link{theme_foundation}()},
\code{\link{theme_igray}()},
\code{\link{theme_par}()}
}
\concept{themes}
