% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-color.R
\name{stat_color}
\alias{stat_color}
\title{Calculate colours from wavelength.}
\usage{
stat_color(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  chroma.type = "CMF",
  x.colour.transform = function(x) {
     x
 },
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{x.colour.transform}{function Applied to \code{x} values before computing
matching colours.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The original data frame with variable \code{wl.color} containing
  colour definitions added.
}
\description{
\code{stat_color} computes colour definitions according to human vision.
}
\details{
For each row in \code{data} a colour definition is computed assuming
  that after transformation with \code{x.colour.transform()} the values in
  \code{x} are wavelengths expressed in nanometres.
}
\section{Computed variable}{

\describe{
  \item{wl.color}{color corresponding to x-value giving wavelength in
  nanometres.}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{color}{after_stat(wl.color)}
  \item{fill}{after_stat(wl.color)}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{

ggplot(sun.spct) +
  geom_line() +
  stat_color() +
  scale_color_identity()

ggplot(sun.spct) +
  geom_line() +
  stat_color(x.colour.transform = function(x) {-x}) +
  scale_color_identity() +
  scale_x_reverse()

ggplot(sun.spct) +
  geom_line() +
  stat_color(x.colour.transform = function(x) {10^x}) +
  scale_color_identity() +
  scale_x_log10()

}
\seealso{
\code{\link[photobiology]{color_of}}, which is used internally.

Other stats functions: 
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
