% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autotitle.R
\name{autotitle}
\alias{autotitle}
\alias{ggtitle_spct}
\title{Add title, subtitle and caption to a spectral plot}
\usage{
autotitle(
  object,
  object.label = deparse(substitute(object)),
  annotations = "title",
  time.format = NULL,
  tz = "",
  default.title = "title:objt"
)

ggtitle_spct(
  object,
  object.label = deparse(substitute(object)),
  annotations = "title",
  time.format = NULL,
  tz = "",
  default.title = "title:objt"
)
}
\arguments{
\item{object}{generic_spct or generic_mspct The spectral object plotted.}

\item{object.label}{character The name of the object being plotted.}

\item{annotations}{character vector Annotations as described for
\code{plot()} methods, values unrelated to title are ignored.}

\item{time.format}{character Format as accepted by
\code{\link[base]{strptime}}.}

\item{tz}{character time zone used in labels.}

\item{default.title}{character vector The default used for \code{annotations
= "title"}.}
}
\value{
The return value of \code{ggplot2::labs()}.
}
\description{
Add a title, subtitle and caption to a spectral plot based on automatically
extracted metadata from an spectral object.
}
\note{
Method renamed as \code{autotitle()} to better reflect its function;
\code{ggtitle_spct()} is deprecated but will remain available for backwards
compatibility.
}
\section{Title Annotations}{
 metadata retrieved from object \code{object} is
  paased to \code{ggplot2::ggtitle()} as arguments for \code{title},
  \code{subtitle} and \code{caption}. The specification for the title is
  passed as argument to \code{annotations}, and consists in the keyword
  \code{title} with optional modifiers selecting the kind of metatdata to
  use, separated by colons. Up to three keywords separated by colons are
  accepted, and correspond to title, subtitle and caption. The recognized
  keywords are: \code{"objt"}, \code{"class"}, \code{"what"}, \code{"when"},
  \code{"where"}, \code{"how"}, \code{"inst.name"}, \code{"inst.sn"},
  \code{"comment"} and \code{"none"} are recognized as modifiers to
  \code{"title"}; \code{"none"} is a placeholder. Default is
  \code{"title:objt"} or no title depending on the context.
}

\examples{

p <- ggplot(sun.spct) +
  geom_line()

p + autotitle(sun.spct)
p + autotitle(sun.spct, object.label = "The terrestrial solar spectrum")
p + autotitle(sun.spct, annotations = "title:objt:class")
p + autotitle(sun.spct, annotations = "title:where:when:how")

p <- ggplot(sun_evening.spct) +
  aes(linetype = spct.idx) +
  geom_line()

p + autotitle(sun_evening.spct, annotations = "title:objt:class")
p + autotitle(sun_evening.spct, annotations = "title:where:when:how")
p + autotitle(sun_evening.spct, annotations = "title:none:none:how")

p <- ggplot(sun_evening.mspct) +
  aes(linetype = spct.idx) +
  geom_line()

p + autotitle(sun_evening.mspct, annotations = "title:objt:class")

}
